/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.container.ContainerCrafterManager;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.GuiCrafterManager;
import com.raoulvdberge.refinedstorage.network.MessageCrafterManagerRequestSlotData;
import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MessageCrafterManagerSlotSizes
implements IMessage,
IMessageHandler<MessageCrafterManagerSlotSizes, IMessage> {
    private Map<String, List<IItemHandlerModifiable>> containerData;
    private final Map<String, Integer> containerDataClient = new LinkedHashMap<String, Integer>();

    public MessageCrafterManagerSlotSizes(Map<String, List<IItemHandlerModifiable>> containerData) {
        this.containerData = containerData;
    }

    public MessageCrafterManagerSlotSizes() {
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.containerDataClient.put(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.containerData.size());
        for (Map.Entry<String, List<IItemHandlerModifiable>> entry : this.containerData.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            int slots = 0;
            for (IItemHandlerModifiable handler : entry.getValue()) {
                slots += handler.getSlots();
            }
            buf.writeInt(slots);
        }
    }

    public IMessage onMessage(MessageCrafterManagerSlotSizes message, MessageContext ctx) {
        GuiBase.executeLater(GuiCrafterManager.class, crafterManager -> {
            ((ContainerCrafterManager)crafterManager.field_147002_h).initSlots(message.containerDataClient);
            RS.INSTANCE.network.sendToServer((IMessage)new MessageCrafterManagerRequestSlotData());
        });
        return null;
    }
}

